#include	<iostream>
#include	<cmath>
#include	<algorithm>
using namespace std;

/*DZEK VRABAC

- Dvodimenzionalni brod (x,y)
	Pramac (0,0)
	Krma (10^9, 0)
	n Jarbola
	
	Na brodu ima n jarbola:
		na udaljenostima (x1,x2,...,xn) OD pramca broda (znaci od 0,0 do jarbola)
		visine jarbola (h1,h2,...,hn)

	Izmedju 2 susedna jarbola vezan je MAGICNI KANAP
		Linija koja jednog trenutka ima nagib -1 a odatle +1
		Tacka promene nagiba

	Zadatak:
		Za svaki jarbol koliko mu je blizu najblizi deo na brodu (tacka na jarbolu ili kanapu) koji je barem te visine

	Ako nema takvog ispisati -1

*/

long long indeksi[1000000];
long long x[1000000];
long long h[1000000];
int n;

/*
	Proveravamo tacke:
		1. Sam Jarbol
		2. Levi Jarbol
		3. Desni Jarbol

	Najbliza tacka je uvek sam vrh jarbola ILI susedni jarbol ako je visi ili jednaki
*/

/*
	for (int i = 0; i < n; i++) {
		int id = indeksi[i];
		cout << x[id] << " " << h[id] << endl;
	}
*/

long long udaljenost(int i)
{
	int id = indeksi[i];
	long long x0 = x[id];
	long long h0 = h[id];
	long long najblizi = -1;

	if (i > 0)
	{
		int levi = indeksi[i - 1];
		long long x_levi = x[levi];
		long long h_levi = h[levi];

		long long levo_tackaNaX = -1;
		if (h_levi >= h0)
		{
			long long kandidat1 = x_levi + (h0 - h_levi);
			levo_tackaNaX = kandidat1;
		}

		if (levo_tackaNaX != -1)
		{
			long long udalj1 = x0 - levo_tackaNaX;
			if (najblizi == -1 || udalj1 < najblizi)
				najblizi = udalj1;
		}
	}

	if (i < n - 1)
	{
		int desni = indeksi[i + 1];
		long long x_desni = x[desni];
		long long h_desni = h[desni];

		long long desno_tackaNaX = -1;
		if (h_desni >= h0) {
			long long kandidat2 = x_desni - (h_desni - h0);
			desno_tackaNaX = kandidat2;
		}

		if (desno_tackaNaX != -1)
		{
			long long udalj2 = desno_tackaNaX - x0;
			if (najblizi == -1 || udalj2 < najblizi)
				najblizi = udalj2;
		}
	}

	return najblizi;
}


int main()
{
	cin >> n;

	for (int i = 0; i < n; i++)
	{
		cin >> x[i];
	}

	for (int i = 0; i < n; i++)
	{
		cin >> h[i];
	}

	for (int i = 0; i < n; i++)
	{
		indeksi[i] = i;
	}

	sort(indeksi, indeksi + n, [&](int a, int b) {
		return x[a] < x[b];
	});

	for (int i = 0; i < n; i++)
	{
		cout << udaljenost(i) << "\n";
	}

	return 0;
}